package control;

import java.util.Arrays;

import abstraction.State;
/**
 * @author Balestra Concetta
 * @version 1.2 09/04/20
 * @since JDK 1.6
 */

/**
 * This Class contains a set of state, one for each available service
 */
public class CState{

	private State[] commState;
	
	public CState(State[] array) {
		commState = new State[array.length];
		for(int i=0; i<array.length; i++)
			commState[i] = array[i];
	}
	
	/**
	 * gets a state of a service specified by the posistion
	 * @param index - position of the state 
	 * @return a state
,	 */
	public State get(int index) {
		return commState[index];
	}
	
	/**
	 * gets the number of states which are in an object CState
	 * @return an integer
	 */
	public int getSize() {
		return this.commState.length;
	}
	
	/**
	 * creates a new community state replacing the element in the specified position 
	 * of an existing community state with a next state of an available service
	 * @param i - the position in which you want to replace
	 * @param next - the state to set in the position i
	 * @return CState created
	 */
	public CState buildNewState (int i, State next) {
		State[] newRec = commState.clone();
		newRec[i]= next;
		return new CState(newRec);
	}
	
	
	public boolean equals(Object o) {
    	if (o != null && getClass().equals(o.getClass())) {
    		CState other = (CState)o;
    		return Arrays.deepEquals(this.commState, other.commState);
    	}
    	else 
    		return false;
    }
	
	public int hashCode() {
		int code=0;
		for (int k =0; k<this.commState.length; k++) {
			code += this.commState[k].hashCode();
		}
        return code; 
    } 
	
	public String toString () {
		StringBuilder cs = new StringBuilder();
		for (int i=0; i< this.commState.length; i++) {
			cs = cs.append(commState[i]);
		}
		return cs.toString();
	}	
}
